// ------------------------------------
//       STDIO.H CONSOLE INTERFACE 
//            Version 2.03
// by:Harry Konstas & Philippe Guillot
//            March 4, 2002 
// ------------------------------------ 

#define strlen StrLen 
#define strstr StrStr 
#define strchr StrChr
#define strcmp StrCompare 
#define strcpy StrCopy 
#define strcat StrCat 
#define sprintf StrPrintF 
#define malloc MemPtrNew 
#define free MemPtrFree 
#define fabs AbsFloat 
#define atof AtoFloat 
#define atol StrAToI 
 
#define FILE DOCFILE 
#define O_RDONLY (0x0002U)  
#define O_WRONLY (0x0005U)  
#define O_RDWR   (0x0006U)  
#define O_APPEND (0x0006U)  
#define O_CREAT  (0x0008U)  
#define O_BINARY (0x0000U) 
 
#define S_IREAD    200  /* Read permitted. (Always true anyway)   */ 
#define S_IWRITE   400  /* Write permitted                        */ 
 
#define SEEK_SET   0    /* offset from begining of file        */ 
#define SEEK_CUR   1    /* offset from current file pointer    */ 
#define SEEK_END   2    /* offset from end of file             */ 
 
#define FA_NORMAL  (0x00000020UL) /* "normal" file                            */ 
#define FA_RDONLY  (0x00000001UL) /* read only                                */ 
#define FA_HIDDEN  (0x00000002UL) /* hidden file                              */ 
#define FA_SYSTEM  (0x00000004UL) /* system file                              */ 
#define FA_DIREC   (0x00000010UL) /* subdirectory                             */ 
#define FA_ARCH    (0x00000020UL) /* archive                                  */ 
#define FA_ALL     (0x0000007fUL) /* matches anything for FfsFindfirst()      */ 

// POSIX error codes 
#define EIO       15  // i/o error 
#define ENOENT    22  // no such file or directory 
#define ENOMEM    25  // not enought memory 
#define ENOSPC    26  // no space on drive 
#define ENOSYS    27  // not imlemented 

#define EOF  -1
 
// video modes 
#define BW40 0 
#define BW80 1 


// ------------------------------------  
//            Structures
// ------------------------------------  

typedef struct { 
  int compressed; 
  int spare; 
  ULong DocSize; 
  UInt rNum; 
  UInt rSize; 
  ULong position; 
  int spare2;         // SmartDoc 
}DOCHEADER; 
 
typedef struct 
{
  UInt16 mode;
  DOCHEADER *pHeader; // pointer to header ( new doc mode ) 
  DmOpenRef db;      // database reference 
  int iRec;          // current record ( read mode ) 
  int nRecs;         // read mode : record number 
                     // new doc   : -1 
                     // console   : -2 
  ULong  RecSize;    // char left to read in current record ( read mode ) 
  Handle hFile;      // handle to current record ( read mode ) 
  Byte   *pData;     // pointer to data ( read mode ) 
  VoidHand hBuff;    // handle to buffer ( write mode ) 
  int iBuff;         // char number in buffer ( new doc  mode ) 
  char *buffer;      // pointer to buffer ( new doc mode ) 
}DOCFILE; 
 

// ------------------------------------  
//         Global Variables
// ------------------------------------  

extern FILE *stdout, *stderr, *stdin;
extern int errno, cfcard; 

 
// ------------------------------------  
//             prototypes 
// ------------------------------------  

int main(int argc, char *argv[]); 
void exit(int); 
void fclose(FILE*pf); 
FILE *fopen(char *fname,char *mode);
int feof(FILE *pF);
char putch(char c); 
void printf(char *fs, ...); 
void fprintf(FILE *pF,char *fs, ...); 
int fgetc(FILE*pf);
char *fgets(char *s, int n, FILE *pF);
char* gets(char*s); 
int fputs(char *s, FILE *pF); 
int puts(char *buf);
int getch(); 
void textmode(int x);
void srand(UInt32 seed); 
int rand(void); 
void beep(void);
int UserAbort(void); 
void clrscr(void);
char *strupr(char *s);
char *getdate(char *buffer);
float atof(char *s);
char *ftoa(double f,char *buf,int prec);
float abs(float x);
int atoi(char *buffer);
char *ltoa(long v,char *buffer,int base); 
unsigned long coreleft(void);
unsigned long stackavail(void);
int chdir(char *path);
char *getcwd(char *buf, int buflen);
long open(char *fname, int flags, int mode); 
int close(long h);
long read(long h,void *buf,long size);
long write(long h,void *buf,long size);
long lseek(long h,long offset,int origin); 
int remove(char *fname);
int rename(char *oldname,char *newname);
long getdfree(void);
int mkdir(char *dirname);
int rmdir(char *dirname);
int fread(void *pData,unsigned int size,unsigned int blocks,FILE *pF);
int fwrite(void *pData,unsigned int size,unsigned int blocks,FILE *pF);
int isalpha(int c);
int toupper(int c);
int isdigit(int c);
int tolower(int c);
int fputc(int c,FILE *pF);
long strtol(char*,char**,int);
double strtod(char*,char**);

